// price-range-slider
(function ($) {
  // $('#price-range-submit').hide();
  $("#min_price,#max_price").on('change', function () {
    $('#price-range-submit').show();
    var min_price_range = parseInt($("#min_price").val());
    var max_price_range = parseInt($("#max_price").val());
    if (min_price_range > max_price_range) {
      $('#max_price').val(min_price_range);
    }
    $("#slider-range").slider({
      values: [min_price_range, max_price_range]
    });
  });

  $("#min_price,#max_price").on("paste keyup", function () {
    $('#price-range-submit').show();
    var min_price_range = parseInt($("#min_price").val());
    var max_price_range = parseInt($("#max_price").val());
    if (min_price_range == max_price_range) {
      max_price_range = min_price_range + 100;
      $("#min_price").val(min_price_range);
      $("#max_price").val(max_price_range);
    }
    $("#slider-range").slider({
      values: [min_price_range, max_price_range]
    });
  });
  $(function () {
    $("#slider-range").slider({
      range: true,
      orientation: "horizontal",
      min: 0,
      max: 700191,
      values: [0, 700191],
      step: 100,
      slide: function (event, ui) {
        if (ui.values[0] == ui.values[1]) {
          return false;
        }
        $("#min_price").val(ui.values[0]);
        $("#max_price").val(ui.values[1]);
      }
    });
    $("#min_price").val($("#slider-range").slider("values", 0));
    $("#max_price").val($("#slider-range").slider("values", 1));

  });
  $("#slider-range,#price-range-submit").click(function () {
    var min_price = $('#min_price').val();
    var max_price = $('#max_price').val();
    $("#searchResults").text("Price " + "$" + min_price + " " + "-" + " " + "$" + max_price + ".");
  });
  $("#searchResults").text("Price Range: $0 - $700191");
})(jQuery);
// price-range-slider


// toggle password
$(".toggle-password").click(function () {
  $(this).toggleClass("fa-eye fa-eye-slash");
  var input = $($(this).attr("toggle"));
  if (input.attr("type") == "password") {
    input.attr("type", "text");
  } else {
    input.attr("type", "password");
  }
});
// toggle password


// 6-digits code
(function () {
  const inputs = Array.from(document.querySelectorAll('.input-control'));
  // Allow only digits, auto-advance, backspace behaviour
  inputs.forEach((input, idx) => {
    input.addEventListener('input', (e) => {
      const val = e.target.value.replace(/\D/g, ''); // keep digits only
      e.target.value = val.slice(0, 1); // only one char
      if (val && idx < inputs.length - 1) {
        inputs[idx + 1].focus();
        inputs[idx + 1].select();
      }
    });

    input.addEventListener('keydown', (e) => {
      if (e.key === 'Backspace' && !e.target.value && idx > 0) {
        // move to previous if empty
        inputs[idx - 1].focus();
        inputs[idx - 1].select();
      } else if (e.key === 'ArrowLeft' && idx > 0) {
        inputs[idx - 1].focus();
      } else if (e.key === 'ArrowRight' && idx < inputs.length - 1) {
        inputs[idx + 1].focus();
      }
    });

    // Handle paste on each input (also below global paste handler)
    input.addEventListener('paste', handlePaste);
  });

  // Global paste: if user pastes 6-digit code anywhere inside digits area
  function handlePaste(e) {
    e.preventDefault();
    const paste = (e.clipboardData || window.clipboardData).getData('text').trim();
    const digits = paste.replace(/\D/g, '').split('').slice(0, inputs.length);
    digits.forEach((d, i) => {
      inputs[i].value = d;
    });
    // focus after the last filled input
    const last = Math.min(digits.length, inputs.length) - 1;
    if (last >= 0 && inputs[last]) inputs[last].focus();
  }

  // combine values to single PIN
  window.getPinValue = function () {
    return inputs.map(i => i.value || '').join('');
  };

  // form submit handler (example)
  window.handleSubmit = function (evt) {
    evt.preventDefault();
    const pin = getPinValue();
    if (pin.length !== inputs.length) {
      alert('Please enter complete 6-digit code');
      // focus first empty
      const firstEmpty = inputs.find(i => i.value === '');
      if (firstEmpty) firstEmpty.focus();
      return false;
    }
    // Example: send to server via fetch or show in console
    console.log('PIN submitted:', pin);
    alert('PIN: ' + pin); // remove in production
    // return true if you want normal form submit
    return false;
  };

  // optional: auto-focus first on page load
  window.addEventListener('DOMContentLoaded', () => {
    setTimeout(() => inputs[0].focus(), 100);
  });
})();
// 6-digits code



document.addEventListener("DOMContentLoaded", function () {
    let currentStep = 1;
    const totalSteps = 4;

    const prevBtn = document.querySelector(".btn-prev");
    const nextBtn = document.querySelector(".btn-next");
    const steps = document.querySelectorAll(".my-step");
    const stepHeads = document.querySelectorAll(".step-head");

    // Function to show the current step
    function showStep(step) {
        steps.forEach((el, i) => {
            el.classList.toggle("active", i + 1 === step);
            el.style.display = (i + 1 === step) ? "block" : "none";
        });

        // Step head active state logic
        stepHeads.forEach((head, i) => {
            if (i + 1 <= step && step <= 3) {
                head.classList.add("active");
            } else {
                head.classList.remove("active");
            }
        });

        // Button visibility & text logic
        if (step === 1) {
            prevBtn.style.display = "inline-block";
            nextBtn.style.display = "inline-block";
            prevBtn.textContent = "Close";
            prevBtn.setAttribute("data-bs-dismiss", "modal");
            nextBtn.textContent = "Next";
        } 
        else if (step === 2) {
            prevBtn.style.display = "inline-block";
            nextBtn.style.display = "inline-block";
            prevBtn.textContent = "Back";
            prevBtn.removeAttribute("data-bs-dismiss");
            nextBtn.textContent = "Next";
        } 
        else if (step === 3) {
            prevBtn.style.display = "inline-block";
            nextBtn.style.display = "inline-block";
            prevBtn.textContent = "Back";
            nextBtn.textContent = "Create";
        } 
        else if (step === 4) {
            // Hide footer buttons on Thank You step
            prevBtn.style.display = "none";
            nextBtn.style.display = "none";
        }
    }

    // Next button click
    nextBtn.addEventListener("click", () => {
        if (currentStep < totalSteps) {
            currentStep++;
            showStep(currentStep);
        }
    });

    // Prev button click
    prevBtn.addEventListener("click", () => {
        if (currentStep > 1) {
            currentStep--;
            showStep(currentStep);
        }
    });

    // Initialize first step
    showStep(currentStep);
});
