<?php include 'include/links.php'; ?>

<main id="body-inner">
    <?php include 'include/header.php'; ?>
    <div id="tt-content-wrap">
        <div id="page-header" class="ph-full ph-full-m ph-cap-xxxlg ph-image-parallax ph-caption-parallax">
            <div class="page-header-inner tt-wrap">
                <div class="ph-caption">
                    <div class="ph-caption-inner">
                        <h2 class="ph-caption-subtitle">Web Design & Development</h2>   
                        <h1 class="ph-caption-title">FUTURE-FOCUSED <br>WEB DESIGN <span class="text-main"> & </span> DEVELOPMENT</h1>
                    </div>
                </div>
            </div>
            <div class="page-header-inner ph-mask">
                <div class="ph-mask-inner tt-wrap">
                    <div class="ph-caption">
                        <div class="ph-caption-inner"> 
                        <h2 class="ph-caption-subtitle">Web Design & Development</h2>   
                        <h1 class="ph-caption-title">DESIGNING THE<br> FUTURE,<span class="text-main"> LINE</span> BY LINE</h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ph-btn tt-wrap">
			    <div class="magnetic-wrap tt-magnetic-btn"><a href="tel:<?php echo $number?>" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item">Get a Quote</a></div>
			    <div class="magnetic-wrap tt-magnetic-btn"><a href="contact" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item dark"> Live Chat</a></div>
			</div>
        </div>
        <div id="tt-page-content">
            <div class="tt-section no-padding-bottom">
                <div class="tt-section-inner max-width-2200">
                    <div id="portfolio-grid" class="pgi-hover">
                        <div class="tt-grid ttgr-layout-creative-2 ttgr-gap-4">
                            <div class="tt-grid-top display-flex tt-justify-content-end no-padding-bottom">
                                <a href="portfolio" class="tt-btn tt-btn-link tt-magnetic-item">
                                    <span class="tt-btn-icon hide-from-sm"><i class="tt-btn-line"></i></span>
                                    <span data-hover="See All Projects">See All Projects</span>
                                </a>
                            </div>
                            <div class="tt-grid-items-wrap isotope-items-wrap">
                                <div class="tt-grid-item isotope-item lifestyle">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf1.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item lifestyle">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf2.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item artistic">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                  <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf3.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item artistic">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf4.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item wellness">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf5.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section no-padding">
                <div class="tt-section-inner">
                    <div class="tt-scrolling-text-crossed">
                        <div class="tt-scrolling-text-crossed-inner">
                            <div class="tt-scrolling-text scrt-dyn-separator scrt-color-reverse" data-scroll-speed="7"
                                data-change-direction="true" data-opposite-direction="true">
                                <div class="tt-scrt-inner">
                                    <div class="tt-scrt-content">
                                        Over 15 years of experience
                                        <span class="tt-scrt-separator">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                <path
                                                    d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-scrolling-text scrt-dyn-separator" data-scroll-speed="7"
                                data-change-direction="true">
                                <div class="tt-scrt-inner">
                                    <div class="tt-scrt-content">
                                        Over 15 years of experience
                                        <span class="tt-scrt-separator">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                <path
                                                    d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section padding-top-xlg-140 padding-bottom-xlg-120 border-top">
				<div class="tt-section-inner tt-wrap">
					<div class="tt-row">
						<div class="tt-col-lg-5">
							<div class="tt-video ttv-portrait ttv-grayscale">
								<div class="tt-anim-zoomin-wrap" style="overflow: hidden;">
								<img src='https://cdn.dribbble.com/userupload/45036463/file/4cdb50def8295fde6a1e7048d586b4a7.png?resize=1024x768&vertical=center'>
								</div>
							</div>
							<div class="tt-text-uppercase margin-top-30 tt-text-reveal">
							    <span style="background-size: 0% 100%;">
								Creative designer<br> based in California
							    </span>
							</div>
						</div>
						<div class="tt-col-lg-7 tt-align-self-center">
							<div class="abot_txt">
							   <h2 class="ph-caption-title">WEBSITES THAT WORK & WOW</h2>
							   <p>Your website is often the first interaction customers have with your brand, and first impressions matter. At California Web Hub, we design and develop high-performing websites that combine visual excellence, seamless functionality, and user-focused experiences. Our websites are built to engage visitors, communicate value clearly, and convert traffic into measurable business results.
							   </p>
							   <div class="ph-btn">
    							    <div class="magnetic-wrap"><a href="tel:<?php echo $number?>" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item">
    							        Get in Touch
    							        </a>
    							     </div>
    							    <div class="magnetic-wrap"><a href="contact" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item dark">
    							        Live Chat Now</a>
    							     </div>
    							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
            <div class="tt-section no-padding-bottom padding-bottom-xlg-80">
                <div class="tt-section-inner tt-wrap">
                    <div class="tt-row">
                        <div class="tt-col-xl-8">
                            <div class="tt-heading tt-heading-xxxlg no-margin">
                                <h3 class="tt-heading-subtitle tt-text-reveal">What We Do</h3>
                                <h2 class="tt-heading-title tt-text-reveal">SERVICES</h2>
                            </div>
                        </div>
                        <div class="tt-col-xl-4 tt-align-self-end margin-top-40">
                            <div class="tt-text-uppercase max-width-400 margin-bottom-20 text-pretty tt-text-reveal">
                                Strategic digital solutions that help brands stand out, connect with the right audience, and achieve sustainable growth.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section">
                <div class="tt-section-inner">
                    <div class="tt-accordion tt-ac-xxlg tt-ac-hover tt-ac-counter tt-ac-borders">
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Strategy, Discovery & Planning</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Every successful website begins with a clear plan. We start by understanding your business objectives, target audience, industry, and competitors. This discovery phase allows us to define site architecture, user journeys, functionality requirements, and content structure.</p>
                                <p>Our strategic planning ensures your website is not only visually appealing but also purpose-driven. By aligning design and development with business goals, we create websites that guide users intuitively and support conversions from the first visit.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">UI/UX Design & User Experience</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Great design is more than aesthetics, it’s about usability. Our UI/UX design process focuses on creating intuitive, engaging, and accessible experiences for users. We design clean layouts, clear navigation, and visually consistent interfaces that enhance user interaction.</p>
                                <p>Every design decision is made with the end user in mind. By optimizing user flows and reducing friction points, we ensure your website delivers a seamless experience across desktops, tablets, and mobile devices.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Custom Web Development</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>We build websites using modern, scalable technologies that prioritize performance, security, and flexibility. Our development approach ensures your website loads fast, functions smoothly, and adapts easily as your business grows.</p>
                                <p>From content management systems to custom functionality and integrations, we develop solutions tailored to your needs. Our clean, maintainable code ensures long-term reliability while supporting future updates and enhancements.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>

                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Responsive, SEO & Performance Optimization</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>A high-performing website must be discoverable and accessible. We optimize every website for responsiveness, search engines, and speed. This includes mobile-first design, clean code structure, SEO-friendly architecture, and performance optimization.</p>
                                <p>By improving page load times and technical SEO elements, we help your website rank better in search results while delivering a smooth experience for users. The result is a website that performs well for both search engines and real visitors.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Testing, Launch & Ongoing Support</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Before launch, we rigorously test your website for functionality, compatibility, security, and performance across devices and browsers. This ensures a smooth and error-free launch experience.</p>
                                <p>Our support doesn’t end at launch. We offer ongoing maintenance, updates, and performance monitoring to keep your website secure, optimized, and aligned with evolving business needs. As your business grows, your website grows with you.
                                </p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include "include/component/book-a-call.php"?>
            <?php include "include/component/testimonial.php"?>
            <?php include "include/component/cta.php"?>
        </div>
        <?php include 'include/footer.php'; ?>
    </div>
</main>
<?php include 'include/script.php'; ?>