<?php include 'include/links.php'; ?>

<main id="body-inner">
    <?php include 'include/header.php'; ?>
    <div id="tt-content-wrap">
        <div id="page-header" class="ph-full ph-full-m ph-cap-xxxlg ph-image-parallax ph-caption-parallax">
            <div class="page-header-inner tt-wrap">
                <div class="ph-caption">
                    <div class="ph-caption-inner">
                        <h2 class="ph-caption-subtitle">ANIMATION</h2>      
                        <h1 class="ph-caption-title">TURNING MOTION<br> <span class="text-main">INTO</span> MEANING</h1>
                    </div>
                </div>
            </div>
            <div class="page-header-inner ph-mask">
                <div class="ph-mask-inner tt-wrap">
                    <div class="ph-caption">
                        <div class="ph-caption-inner"> 
                        <h2 class="ph-caption-subtitle">ANIMATION</h2>       
                        <h1 class="ph-caption-title">STORIES<br><span class="text-main"> IN</span> MOTION.</h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ph-btn tt-wrap">
			    <div class="magnetic-wrap tt-magnetic-btn"><a href="tel:<?php echo $number?>" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item">Get a Quote</a></div>
			    <div class="magnetic-wrap tt-magnetic-btn"><a href="contact" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item dark"> Live Chat</a></div>
			</div>
        </div>
        <div id="tt-page-content">
            <div class="tt-section no-padding-bottom">
                <div class="tt-section-inner max-width-2200">
                    <div id="portfolio-grid" class="pgi-hover">
                        <div class="tt-grid ttgr-layout-creative-2 ttgr-gap-4">
                            <div class="tt-grid-top display-flex tt-justify-content-end no-padding-bottom">
                                <a href="portfolio" class="tt-btn tt-btn-link tt-magnetic-item">
                                    <span class="tt-btn-icon hide-from-sm"><i class="tt-btn-line"></i></span>
                                    <span data-hover="See All Projects">See All Projects</span>
                                </a>
                            </div>
                            <div class="tt-grid-items-wrap isotope-items-wrap">
                                <div class="tt-grid-item isotope-item lifestyle">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                         <video src='https://cdn.dribbble.com/userupload/12561734/file/original-8020894fde5ead0da3e78d4eb428a34d.mp4' autoplay muted loop></video>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item lifestyle">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <video src='https://cdn.dribbble.com/userupload/45040915/file/20673e31c99cd10ea0900e5dbf82e46f.mp4' autoplay muted loop></video>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item artistic">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                                <a href="void:;" class="pgi-image-wrap">
                                                  <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <video src='https://cdn.dribbble.com/userupload/45250113/file/ef1c5e776b102c04fd35e6fcd8b74542.mp4' autoplay muted loop></video>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item artistic">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <video src='https://cdn.dribbble.com/userupload/45047276/file/2f419f53a44a1fcbcff1c1c042510764.mp4' autoplay muted loop></video>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item wellness">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <video src='https://cdn.dribbble.com/userupload/15247714/file/original-61fad45a71444c26ea507c3d943e2e20.mp4' autoplay muted loop></video>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section no-padding">
                <div class="tt-section-inner">
                    <div class="tt-scrolling-text-crossed">
                        <div class="tt-scrolling-text-crossed-inner">
                            <div class="tt-scrolling-text scrt-dyn-separator scrt-color-reverse" data-scroll-speed="7"
                                data-change-direction="true" data-opposite-direction="true">
                                <div class="tt-scrt-inner">
                                    <div class="tt-scrt-content">
                                        Over 15 years of experience
                                        <span class="tt-scrt-separator">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                <path
                                                    d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-scrolling-text scrt-dyn-separator" data-scroll-speed="7"
                                data-change-direction="true">
                                <div class="tt-scrt-inner">
                                    <div class="tt-scrt-content">
                                        Over 15 years of experience
                                        <span class="tt-scrt-separator">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                <path
                                                    d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section padding-top-xlg-140 padding-bottom-xlg-120 border-top">
				<div class="tt-section-inner tt-wrap">
					<div class="tt-row">
						<div class="tt-col-lg-5">
							<div class="tt-video ttv-portrait ttv-grayscale">
								<div class="tt-anim-zoomin-wrap" style="overflow: hidden;">
								    <video src='https://cdn.dribbble.com/userupload/45196656/file/c38975026658da8a9eaf8e542df5b591.mp4' autoplay muted loop></video>
								</div>
							</div>
							<div class="tt-text-uppercase margin-top-30 tt-text-reveal">
							    <span style="background-size: 0% 100%;">
								Creative designer<br> based in California
							    </span>
							</div>
						</div>
						<div class="tt-col-lg-7 tt-align-self-center">
							<div class="abot_txt">
							   <h2 class="ph-caption-title">WHERE DESIGN COMES ALIVE</h2>
							   <p>At California Web Hub, we use animation to transform ideas into experiences. Animation isn’t just movement, it’s a powerful storytelling tool that captures attention, simplifies complex messages, and leaves a lasting impression. From subtle motion design to dynamic animated content, we create visuals that engage, educate, and inspire action.
							   </p>
							   <div class="ph-btn">
    							    <div class="magnetic-wrap"><a href="tel:<?php echo $number?>" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item">
    							        Get in Touch
    							        </a>
    							     </div>
    							    <div class="magnetic-wrap"><a href="contact" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item dark">
    							        Live Chat Now</a>
    							     </div>
    							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
            <div class="tt-section no-padding-bottom padding-bottom-xlg-80">
                <div class="tt-section-inner tt-wrap">
                    <div class="tt-row">
                        <div class="tt-col-xl-8">
                            <div class="tt-heading tt-heading-xxxlg no-margin">
                                <h3 class="tt-heading-subtitle tt-text-reveal">What We Do</h3>
                                <h2 class="tt-heading-title tt-text-reveal">SERVICES</h2>
                            </div>
                        </div>
                        <div class="tt-col-xl-4 tt-align-self-end margin-top-40">
                            <div class="tt-text-uppercase max-width-400 margin-bottom-20 text-pretty tt-text-reveal">
                                Strategic digital solutions that help brands stand out, connect with the right audience, and achieve sustainable growth.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section">
                <div class="tt-section-inner">
                    <div class="tt-accordion tt-ac-xxlg tt-ac-hover tt-ac-counter tt-ac-borders">
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Concept Development & Storyboarding</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Every impactful animation starts with a strong idea. We begin by understanding your goals, audience, and message, then translate that vision into a clear creative concept. Through detailed storyboarding, we map out every scene, movement, and transition to ensure the final animation flows seamlessly and tells a compelling story.</p>
                                <p>This planning phase allows us to align creativity with strategy. By visualizing the animation before production begins, we ensure clarity, consistency, and efficiency while delivering a final result that communicates your message with precision and impact.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Motion Graphics & Visual Effects</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Motion graphics bring design elements to life. We create visually striking animations that enhance your brand identity while adding depth and energy to your content. From logo animations to dynamic transitions and visual effects, our motion graphics are crafted to feel modern, smooth, and intentional.</p>
                                <p>Rather than overwhelming the viewer, we use motion strategically to highlight key messages and guide attention. The result is clean, polished animation that enhances engagement while maintaining a refined and professional brand presence.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Explainer & Promotional Animations</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Animation is one of the most effective ways to explain complex ideas quickly and clearly. We design explainer animations that simplify your products, services, or processes into engaging visual narratives that are easy to understand and memorable.</p>
                                <p>For promotional content, we create animations that capture attention and drive action. Whether it’s for websites, social media, or digital campaigns, our animations are designed to communicate value instantly while reinforcing your brand message.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>

                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">UI Animation & Interactive Motion</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Thoughtful motion enhances user experience. We design UI animations and micro-interactions that make digital products feel intuitive, responsive, and engaging. Subtle transitions, hover effects, and interactive animations guide users naturally through your website or application.</p>
                                <p>These animations are not just decorative, they improve usability, reduce friction, and create a smoother digital experience. By blending function with creativity, we ensure motion supports both design and performance.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Scalable & Performance-Optimized Animation</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Animation should be visually impressive without compromising performance. We optimize every animation for speed, responsiveness, and cross-platform compatibility, ensuring smooth playback across devices and screen sizes.</p>
                                <p>Our scalable approach allows animations to evolve alongside your brand. Whether you’re expanding your digital presence or launching new campaigns, your animation assets remain flexible, future-ready, and aligned with your brand’s growth.
                                </p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include "include/component/book-a-call.php"?>
            <?php include "include/component/testimonial.php"?>
            <?php include "include/component/cta.php"?>
        </div>
        <?php include 'include/footer.php'; ?>
    </div>
</main>
<?php include 'include/script.php'; ?>