<?php include 'include/links.php'; ?>

<main id="body-inner">
    <?php include 'include/header.php'; ?>
    <div id="tt-content-wrap">
        <div id="page-header" class="ph-full ph-full-m ph-cap-xxxlg ph-image-parallax ph-caption-parallax">
            <div class="page-header-inner tt-wrap">
                <div class="ph-caption">
                    <div class="ph-caption-inner">
                        <h2 class="ph-caption-subtitle">SEARCH ENGINE OPTIMIZATION</h2>                 
                        <h1 class="ph-caption-title">STRATEGIC SEO<br><span class="text-main">FOR</span> GROWTH</h1>
                    </div>
                </div>
            </div>
            <div class="page-header-inner ph-mask">
                <div class="ph-mask-inner tt-wrap">
                    <div class="ph-caption">
                        <div class="ph-caption-inner"> 
                        <h2 class="ph-caption-subtitle">SEARCH ENGINE OPTIMIZATION</h2>             
                        <h1 class="ph-caption-title">RANK HIGHER.<br><span class="text-main"> GROW</span> FASTER.</h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ph-btn tt-wrap">
			    <div class="magnetic-wrap tt-magnetic-btn"><a href="tel:<?php echo $number?>" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item">Get a Quote</a></div>
			    <div class="magnetic-wrap tt-magnetic-btn"><a href="contact" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item dark"> Live Chat</a></div>
			</div>
        </div>
        <div id="tt-page-content">
            <div class="tt-section no-padding-bottom">
                <div class="tt-section-inner max-width-2200">
                    <div id="portfolio-grid" class="pgi-hover">
                        <div class="tt-grid ttgr-layout-creative-2 ttgr-gap-4">
                            <div class="tt-grid-top display-flex tt-justify-content-end no-padding-bottom">
                                <a href="portfolio" class="tt-btn tt-btn-link tt-magnetic-item">
                                    <span class="tt-btn-icon hide-from-sm"><i class="tt-btn-line"></i></span>
                                    <span data-hover="See All Projects">See All Projects</span>
                                </a>
                            </div>
                            <div class="tt-grid-items-wrap isotope-items-wrap">
                                <div class="tt-grid-item isotope-item lifestyle">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/seo-1.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item lifestyle">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/seo-2.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item artistic">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="void:;" class="pgi-image-wrap">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/seo-3.jpg"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section no-padding">
                <div class="tt-section-inner">
                    <div class="tt-scrolling-text-crossed">
                        <div class="tt-scrolling-text-crossed-inner">
                            <div class="tt-scrolling-text scrt-dyn-separator scrt-color-reverse" data-scroll-speed="7"
                                data-change-direction="true" data-opposite-direction="true">
                                <div class="tt-scrt-inner">
                                    <div class="tt-scrt-content">
                                        Over 15 years of experience
                                        <span class="tt-scrt-separator">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                <path
                                                    d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-scrolling-text scrt-dyn-separator" data-scroll-speed="7"
                                data-change-direction="true">
                                <div class="tt-scrt-inner">
                                    <div class="tt-scrt-content">
                                        Over 15 years of experience
                                        <span class="tt-scrt-separator">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                <path
                                                    d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section padding-top-xlg-140 padding-bottom-xlg-120 border-top">
				<div class="tt-section-inner tt-wrap">
					<div class="tt-row">
						<div class="tt-col-lg-5">
							<div class="tt-video ttv-portrait ttv-grayscale">
								<div class="tt-anim-zoomin-wrap" style="overflow: hidden;">
								<img src='https://cdn.dribbble.com/userupload/45036463/file/4cdb50def8295fde6a1e7048d586b4a7.png?resize=1024x768&vertical=center'>
								</div>
							</div>
							<div class="tt-text-uppercase margin-top-30 tt-text-reveal">
							    <span style="background-size: 0% 100%;">
								Creative designer<br> based in California
							    </span>
							</div>
						</div>
						<div class="tt-col-lg-7 tt-align-self-center">
							<div class="abot_txt">
							   <h2 class="ph-caption-title">CLIMB THE RANKINGS</h2>
							   <p>At California Web Hub, we approach SEO as a long-term growth strategy, not a quick fix. Search Engine Optimization is about visibility, credibility, and sustainable traffic, putting your brand in front of the right audience at the right time. We help businesses rise in search rankings while building a strong digital foundation that drives consistent, qualified traffic.
							   </p>
							   <div class="ph-btn">
    							    <div class="magnetic-wrap"><a href="tel:<?php echo $number?>" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item">
    							        Get in Touch
    							        </a>
    							     </div>
    							    <div class="magnetic-wrap"><a href="contact" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item dark">
    							        Live Chat Now</a>
    							     </div>
    							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
            <div class="tt-section no-padding-bottom padding-bottom-xlg-80">
                <div class="tt-section-inner tt-wrap">
                    <div class="tt-row">
                        <div class="tt-col-xl-8">
                            <div class="tt-heading tt-heading-xxxlg no-margin">
                                <h3 class="tt-heading-subtitle tt-text-reveal">What We Do</h3>
                                <h2 class="tt-heading-title tt-text-reveal">SERVICES</h2>
                            </div>
                        </div>
                        <div class="tt-col-xl-4 tt-align-self-end margin-top-40">
                            <div class="tt-text-uppercase max-width-400 margin-bottom-20 text-pretty tt-text-reveal">
                                Strategic digital solutions that help brands stand out, connect with the right audience, and achieve sustainable growth.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section">
                <div class="tt-section-inner">
                    <div class="tt-accordion tt-ac-xxlg tt-ac-hover tt-ac-counter tt-ac-borders">
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">SEO Strategy & Research</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Every successful SEO campaign starts with a clear strategy. We conduct in-depth keyword research, competitor analysis, and market evaluation to identify the most valuable opportunities for your brand. This ensures your website targets search terms that drive real traffic and meaningful engagement.</p>
                                <p>By aligning search intent with your business objectives, we create a customized SEO roadmap designed for growth. Our strategic approach allows your brand to compete effectively, attract qualified users, and build authority within your industry.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">On-Page SEO Optimization</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>On-page SEO is the foundation of search performance. We optimize your website’s structure, content, and metadata to ensure search engines can easily understand and rank your pages. From headings and internal linking to content optimization, every detail is carefully refined.</p>
                                <p>Our focus is not just on rankings, but on user experience. We ensure your pages are clear, engaging, and valuable to visitors, helping search engines and users see your website as trustworthy, relevant, and authoritative.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Technical SEO & Website Performance</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Technical SEO plays a critical role in how search engines evaluate your site. We optimize website speed, mobile responsiveness, crawlability, and indexing to ensure your site performs efficiently across all devices and platforms.</p>
                                <p>By resolving technical barriers and improving performance, we create a strong backend foundation that supports long-term SEO success. A fast, secure, and well-structured website not only ranks better but also delivers a better experience for users.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>

                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Content Optimization & SEO Copywriting</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Content is at the heart of effective SEO. We optimize and create high-quality content that answers user questions, targets valuable keywords, and aligns with your brand voice. Our approach ensures your content attracts traffic while building trust and authority.</p>
                                <p>Through strategic content optimization, we help your website become a reliable resource within your industry. This improves rankings, increases engagement, and encourages visitors to take meaningful action.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Tracking, Reporting & Continuous Growth</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>SEO is an ongoing process, not a one-time task. We continuously monitor performance, track keyword rankings, analyze traffic behavior, and refine strategies based on data and insights. This allows us to adapt quickly and keep your website competitive.</p>
                                <p>With transparent reporting and measurable results, you always know how your SEO is performing. Our goal is continuous improvement, driving consistent growth, stronger visibility, and long-term success for your brand.
                                </p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include "include/component/book-a-call.php"?>
            <?php include "include/component/testimonial.php"?>
            <?php include "include/component/cta.php"?>
        </div>
        <?php include 'include/footer.php'; ?>
    </div>
</main>
<?php include 'include/script.php'; ?>