<?php include 'include/links.php'; ?>

<main id="body-inner">
    <?php include 'include/header.php'; ?>
    <div id="tt-content-wrap">
        <div id="page-header" class="ph-full ph-full-m ph-cap-xxxlg ph-image-parallax ph-caption-parallax">
            <div class="page-header-inner tt-wrap">
                <div class="ph-caption">
                    <div class="ph-caption-inner">
                        <h2 class="ph-caption-subtitle">Website Design</h2>
                        <h1 class="ph-caption-title">Professional <br> Web Design <span class="text-main"> & </span><br> Development</h1>
                    </div>
                </div>
            </div>
            <div class="page-header-inner ph-mask">
                <div class="ph-mask-inner tt-wrap">
                    <div class="ph-caption">
                        <div class="ph-caption-inner">
                        <h2 class="ph-caption-subtitle">Website Design</h2>
                        <h1 class="ph-caption-title">Professional <br> Web Design <span class="text-main"> & </span><br> Development</h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ph-btn tt-wrap">
			    <div class="magnetic-wrap tt-magnetic-btn"><a href="void:;" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item">Get a Quote</a></div>
			    <div class="magnetic-wrap tt-magnetic-btn"><a href="void:;" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item dark"> Live Chat</a></div>
			</div>
        </div>
        <div id="tt-page-content">
            <div class="tt-section no-padding-bottom">
                <div class="tt-section-inner max-width-2200">
                    <div id="portfolio-grid" class="pgi-hover">
                        <div class="tt-grid ttgr-layout-creative-2 ttgr-gap-4">
                            <div class="tt-grid-top display-flex tt-justify-content-end no-padding-bottom">
                                <a href="portfolio" class="tt-btn tt-btn-link tt-magnetic-item">
                                    <span class="tt-btn-icon hide-from-sm"><i class="tt-btn-line"></i></span>
                                    <span data-hover="See All Projects">See All Projects</span>
                                </a>
                            </div>
                            <div class="tt-grid-items-wrap isotope-items-wrap">
                                <div class="tt-grid-item isotope-item lifestyle">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="assets/img/pf1.png" class="pgi-image-wrap" data-fancybox="images"
                                                data-cursor="View<br>Project">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf1.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>

                                            <div class="pgi-caption">
                                                <div class="pgi-caption-inner">
                                                    <h2 class="pgi-title">
                                                        <a href="void:;">Tortillas</a>
                                                    </h2>
                                                    <div class="pgi-categories-wrap">
                                                        <div class="pgi-category">Lifestyle</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item lifestyle">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="assets/img/pf2.png" class="pgi-image-wrap" data-fancybox="images"
                                                data-cursor="View<br>Project">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf2.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>

                                            <div class="pgi-caption">
                                                <div class="pgi-caption-inner">
                                                    <h2 class="pgi-title">
                                                        <a href="void:;">Coffee Shop</a>
                                                    </h2>
                                                    <div class="pgi-categories-wrap">
                                                        <div class="pgi-category">Lifestyle</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item artistic">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="assets/img/pf3.png" class="pgi-image-wrap" data-fancybox="images"
                                                data-cursor="View<br>Project">
                                                  <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf3.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>

                                            <div class="pgi-caption">
                                                <div class="pgi-caption-inner">
                                                    <h2 class="pgi-title">
                                                        <a href="void:;">Fashion Shoot</a>
                                                    </h2>
                                                    <div class="pgi-categories-wrap">
                                                        <div class="pgi-category">Artistic</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item artistic">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="assets/img/pf4.png" class="pgi-image-wrap" data-fancybox="images"
                                                data-cursor="View<br>Project">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf4.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                            <div class="pgi-caption">
                                                <div class="pgi-caption-inner">
                                                    <h2 class="pgi-title">
                                                        <a href="void:;">Postorganic</a>
                                                    </h2>
                                                    <div class="pgi-categories-wrap">
                                                        <div class="pgi-category">Artistic</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="tt-grid-item isotope-item wellness">
                                    <div class="ttgr-item-inner">
                                        <div class="portfolio-grid-item">
                                            <a href="assets/img/pf5.png" class="pgi-image-wrap" data-fancybox="images"
                                                data-cursor="View<br>Project">
                                                <div class="pgi-image-holder">
                                                    <div class="pgi-image-inner tt-anim-zoomin">
                                                        <figure class="pgi-image ttgr-height">
                                                            <img src="assets/img/pf5.png"
                                                                loading="lazy" alt="image">
                                                        </figure>
                                                    </div>
                                                </div>
                                            </a>
                                            <div class="pgi-caption">
                                                <div class="pgi-caption-inner">
                                                    <h2 class="pgi-title">
                                                        <a href="void:;">Embrace Yourself</a>
                                                    </h2>
                                                    <div class="pgi-categories-wrap">
                                                        <div class="pgi-category">Wellness</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section no-padding">
                <div class="tt-section-inner">
                    <div class="tt-scrolling-text-crossed">
                        <div class="tt-scrolling-text-crossed-inner">
                            <div class="tt-scrolling-text scrt-dyn-separator scrt-color-reverse" data-scroll-speed="7"
                                data-change-direction="true" data-opposite-direction="true">
                                <div class="tt-scrt-inner">
                                    <div class="tt-scrt-content">
                                        Over 15 years of experience
                                        <span class="tt-scrt-separator">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                <path
                                                    d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-scrolling-text scrt-dyn-separator" data-scroll-speed="7"
                                data-change-direction="true">
                                <div class="tt-scrt-inner">
                                    <div class="tt-scrt-content">
                                        Over 15 years of experience
                                        <span class="tt-scrt-separator">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                                <path
                                                    d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section padding-top-xlg-140 padding-bottom-xlg-120 border-top">
				<div class="tt-section-inner tt-wrap">
					<div class="tt-row">
						<div class="tt-col-lg-5">
							<div class="tt-video ttv-portrait ttv-grayscale">
								<div class="tt-anim-zoomin-wrap" style="overflow: hidden;">
								<img src='https://cdn.dribbble.com/userupload/45036463/file/4cdb50def8295fde6a1e7048d586b4a7.png?resize=1024x768&vertical=center'>
								</div>
							</div>
							<div class="tt-text-uppercase margin-top-30 tt-text-reveal">
							    <span style="background-size: 0% 100%;">
								Creative designer<br> based in California
							    </span>
							</div>
						</div>
						<div class="tt-col-lg-7 tt-align-self-center">
							<div class="abot_txt">
							   <h2 class="ph-caption-title">Conception, Transformation and Creativity</h2>
							   <p>
							       With over a decade of expertise, we comprehend the current demands and approaches in today's business landscape.
							       We blend imaginative thinking, exceptional designs,
							       inventive strategies, and technological advancements to assist you, whether you aim to establish a dynamic startup or rejuvenate your current brand.
							   </p>
							   <div class="ph-btn">
    							    <div class="magnetic-wrap"><a href="void:;" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item">
    							        Get in Touch
    							        </a>
    							     </div>
    							    <div class="magnetic-wrap"><a href="void:;" class="tt-btn tt-btn-secondary hide-from-xlg tt-magnetic-item dark">
    							        Live Chat Now</a>
    							     </div>
    							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
            <div class="tt-section no-padding-bottom padding-bottom-xlg-80">
                <div class="tt-section-inner tt-wrap">
                    <div class="tt-row">
                        <div class="tt-col-xl-8">
                            <div class="tt-heading tt-heading-xxxlg no-margin">
                                <h3 class="tt-heading-subtitle tt-text-reveal">What I Do</h3>
                                <h2 class="tt-heading-title tt-text-reveal">Services</h2>
                            </div>
                        </div>
                        <div class="tt-col-xl-4 tt-align-self-end margin-top-40">
                            <div class="tt-text-uppercase max-width-400 margin-bottom-20 text-pretty tt-text-reveal">
                                Comprehensive digital services to boost your online presence and
                                achieve impactful results.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section">
                <div class="tt-section-inner">
                    <div class="tt-accordion tt-ac-xxlg tt-ac-hover tt-ac-counter tt-ac-borders">
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Digital Strategy</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Crafting data-driven strategies to elevate your online presence. I
                                    align your business goals with innovative digital solutions, ensuring
                                    measurable growth and a competitive edge in the digital
                                    landscape.
                                </p>
                                <p>In today’s fast-paced digital world, having a clear and actionable
                                    strategy is key to standing out. I specialize in crafting data-driven
                                    digital strategies tailored to your unique business goals. Whether
                                    you’re looking to grow your online presence, improve customer
                                    engagement, or drive conversions, I work closely with you to identify
                                    opportunities and create a roadmap for success. From audience
                                    analysis and competitive research to defining KPIs and optimizing
                                    digital channels, I ensure your strategy is not only innovative but
                                    also measurable and results-oriented. Let’s turn your vision into a
                                    digital reality.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Branding &amp; Identity</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Building brands that resonate. From logos to messaging, I create
                                    cohesive and memorable identities that reflect your values, connect
                                    with your audience, and stand out in the market.</p>
                                <p>Your brand is more than just a logo—it’s the heart and soul of your
                                    business. I help you create a cohesive and memorable brand identity
                                    that resonates with your audience and reflects your core values. From
                                    crafting a unique logo and selecting the perfect color palette to
                                    defining your brand voice and messaging, I ensure every element works
                                    together to tell your story. Whether you’re launching a new brand or
                                    refreshing an existing one, I’ll guide you through the process of
                                    building a strong, authentic identity that stands out in a crowded
                                    market.</p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">UI / UX Design</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">
                                <p>Designing intuitive and engaging experiences. I blend user-centered
                                    design principles with cutting-edge aesthetics to create interfaces
                                    that are not only beautiful but also functional and easy to
                                    navigate.
                                    </p>
                                <p>Great design is more than just aesthetics—it’s about creating
                                    seamless and enjoyable experiences for your users. I specialize in
                                    designing intuitive and user-friendly interfaces that not only look
                                    stunning but also function flawlessly. By combining user-centered
                                    design principles with a deep understanding of your audience, I
                                    create wireframes, prototypes, and final designs that prioritize
                                    usability and engagement. Whether it’s a website, app, or digital
                                    platform, I ensure every interaction feels natural and every detail
                                    enhances the overall experience.</p>

                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>

                            </div>
                        </div>

                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Web Design</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">

                                <p>Transforming ideas into stunning websites. My custom web designs
                                    are tailored to your brand, optimized for performance, and designed
                                    to captivate your audience while driving conversions.</p>

                                <p>Your website is often the first impression you make on potential
                                    customers, and it needs to be unforgettable. I design custom websites
                                    that are visually striking, highly functional, and optimized for
                                    performance. From responsive layouts that look great on any device to
                                    seamless navigation and fast load times, I focus on creating a user
                                    experience that keeps visitors engaged and drives conversions.
                                    Whether you need a simple portfolio site or a complex e-commerce
                                    platform, I’ll work with you to bring your vision to life and create
                                    a website that truly represents your brand.</p>

                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>

                            </div>
                        </div>

                        <div class="tt-accordion-item tt-anim-fadeinup">
                            <div class="tt-accordion-heading">
                                <div class="tt-ac-head cursor-alter">
                                    <div class="tt-ac-head-inner">
                                        <h4 class="tt-ac-head-title">Product Design</h4>
                                    </div>
                                </div>
                                <div class="tt-accordion-caret">
                                    <div class="tt-accordion-caret-inner tt-magnetic-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path
                                                d="M13.025 1l-2.847 2.828 6.176 6.176h-16.354v3.992h16.354l-6.176 6.176 2.847 2.828 10.975-11z">
                                            </path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="tt-accordion-content max-width-1400">

                                <p>Innovating with purpose. I design products that solve real
                                    problems, combining functionality, aesthetics, and user experience to
                                    deliver solutions that users love and businesses rely on.</p>

                                <p>Innovative products start with thoughtful design. I specialize in
                                    creating products that solve real problems and deliver exceptional
                                    user experiences. From initial concept development and user research
                                    to prototyping and final design, I focus on combining functionality,
                                    aesthetics, and usability to create solutions that users love.
                                    Whether it’s a physical product, a digital tool, or something in
                                    between, I’ll work with you to design something that not only meets
                                    your business goals but also exceeds user expectations. Let’s create
                                    products that make an impact.
                                </p>
                                <a href="contact" class="tt-btn tt-btn-outline tt-magnetic-item">
                                    <span data-hover="Let’s Connect!">Let’s Connect!</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="cta-wrapper">
		        <div class="tt-section-inner tt-wrap">
		            <div class="tt-row">
		                <div class="tt-col-lg-6">
		                    <h3 class="ph-caption-title">Creative ideas from real people</h3>
		                        <p>
		                            We’ll ask users what they want and analyze their behaviors to reveal real opportunities for your business.
		                            We question every assumption and validate every idea so you make just-right investments, every time.
		                        </p>
		                        <a href="tel:<?php echo $number?>" class="btn btn-primary">
		                            <span>Book a Free Consultation</span>
		                        </a>
		                        <a href="tel:<?php echo $number?>" class="btn btn-primary">
		                            <span>Live Chat Now</span>
		                        </a>
		                 </div>
		                <div class="tt-col-lg-6">
		                    <img src='https://orbitdesignagency.com/assets/images/cta-img2.png'>
		                </div>
		                 
		                 
		              </div>
		         </div>
		     </div>            
            <div class="tt-section no-padding-bottom">
                <div class="tt-section-inner">
                    <div class="tt-heading tt-heading-center tt-heading-xxlg">
                        <h3 class="tt-heading-subtitle tt-text-reveal">What They Say</h3>
                        <h2 class="tt-heading-title tt-text-reveal">Testimonials</h2>
                        <p class="max-width-500 tt-text-uppercase tt-text-reveal">Genuine words
                            from the people I’ve had the pleasure to work with.</p>
                    </div>
                </div>
            </div>
            <div class="tt-section no-padding-bottom">
                <div class="tt-section-inner max-width-1800">
                    <div class="tt-sticky-testimonials tt-stte-center">
                        <div class="tt-stte-item">
                            <div class="tt-stte-card cursor-alter">
                                <div class="tt-stte-card-counter"></div>
                                <div class="tt-stte-card-caption">
                                    <div class="tt-stte-text">
                                        "One of the best template I've ever had. I love it! It's fully customizable,
                                        well coded, fast and responsive - fitting for all kind of devices".
                                    </div>
                                    <div class="tt-stte-subtext">
                                        <a href="https://themetorium.net/" class="tt-link" target="_blank"
                                            rel="noopener">- Wironimo</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tt-stte-item">
                            <div class="tt-stte-card cursor-alter">
                                <div class="tt-stte-card-counter"></div>
                                <div class="tt-stte-card-caption">
                                    <div class="tt-stte-text">
                                        "Brilliant template. Tons of options, many concepts, design flexibility, code
                                        quality, explanatory comments in each section for easy styling".
                                    </div>
                                    <div class="tt-stte-subtext">- Gneto</div>
                                </div>
                            </div>
                        </div>
                        <div class="tt-stte-item">
                            <div class="tt-stte-card cursor-alter">
                                <div class="tt-stte-card-counter"></div>
                                <div class="tt-stte-card-caption">
                                    <div class="tt-stte-text">
                                        "Easy to customize, plenty of choices to display your portfolio, fast loading
                                        times. Excellent support".
                                    </div>
                                    <div class="tt-stte-subtext">
                                        <a href="https://themetorium.net/" class="tt-link" target="_blank"
                                            rel="noopener">- Brendak</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tt-stte-item">
                            <div class="tt-stte-card cursor-alter">
                                <div class="tt-stte-card-counter"></div>
                                <div class="tt-stte-card-caption">
                                    <div class="tt-stte-text">
                                        "Very nice design and well organised and commented code. Also good customer
                                        service".
                                    </div>
                                    <div class="tt-stte-subtext">- Gazzzzz</div>
                                </div>
                            </div>
                        </div>
                        <div class="tt-stte-item">
                            <div class="tt-stte-card cursor-alter">
                                <div class="tt-stte-card-counter"></div>
                                <div class="tt-stte-card-caption">
                                    <div class="tt-stte-text">
                                        "I founded a bug on Iphone and Ipad and the author fixed very quickly. I
                                        appreciated his efforts and his quickness in solving the problem".
                                    </div>
                                    <div class="tt-stte-subtext">- Admanente</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tt-section padding-top-xlg-180 padding-bottom-xlg-120">
                <div class="tt-section-inner tt-wrap">
                    <div class="tt-row margin-bottom-40">
                        <div class="tt-col-xl-8">
                            <div class="tt-heading tt-heading-xxxlg no-margin">
                                <h3 class="tt-heading-subtitle tt-text-reveal">Contact</h3>
                                <h2 class="tt-heading-title tt-text-reveal">Let's Work<br>
                                    Together</h2>
                            </div>
                        </div>
                        <div class="tt-col-xl-4 tt-align-self-end tt-xl-column-reverse margin-top-40">
                            <div class="max-width-600 margin-bottom-10 tt-text-uppercase text-pretty tt-text-reveal">
                                Feeling good about a new project? Write me what's in your mind<br> and
                                let's talk about it!
                            </div>
                            <div class="tt-big-round-ptn margin-top-30 margin-bottom-xlg-80 tt-anim-fadeinup">
                                <a href="contact" class="tt-big-round-ptn-holder tt-magnetic-item">
                                    <div class="tt-big-round-ptn-inner">Let's<br> Connect!</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php include 'include/footer.php'; ?>
    </div>
</main>
<?php include 'include/script.php'; ?>