<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="robots" content="index,nofollow" />
    <title>Beyond Browse</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    <?php include 'include/variable.php'?>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"
        referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css" />
    <link href="https://www.jqueryscript.net/css/jquerysctipttop.css" rel="stylesheet" type="text/css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Oswald:wght@200..700&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" media="screen" href="css/style.css" />
</head>
<style>
/*Thankyou Page Section Css Start Here*/
.topbar {
    position: relative;
}

section.thankyou-page-wrap {
    background-image: url(./images/banner-bg1.webp);
    padding: 150px 0 100px;
    height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    background-repeat: no-repeat;
    z-index: 1;
    background-size: cover;
    background-position: 100% 100%;
    position: relative;
    z-index: 1;
}

section.thankyou-page-wrap::before {
    position: absolute;
    content: '';
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #000;
    z-index: -1;
    width: 100%;
    height: 100%;
    opacity: .8;
}

.thankyou-page-wrap .thankyou-page-content {
    text-align: center;
}

.thankyou-page-content h1 {
    font-size: 100px;
    line-height: 100px;
    margin: 0 auto 30px;
    width: 75%;
    letter-spacing: 30px;
    position: relative;
    -webkit-text-stroke: 0.3vw #20b8f9;
    color: #F0F7F7;
}

.thankyou-page-content h1::before {
    content: attr(data-text);
    color: #F0F7F7;
    position: absolute;
    top: 0;
    left: 0;
    width: 75%;
    height: 100%;
    margin: 0 auto 30px;
    border-right: 2px solid #20b8f9;
    -webkit-text-stroke: 0vw #20b8f9;
    overflow: hidden;
    animation: animate 6s linear infinite;
}

.thankyou-page-content p {
    color: #F0F7F7;
    margin: 0 0 20px;
}

@keyframes animate {

    0%,
    10%,
    100% {
        width: 0;
    }

    70%,
    90% {
        width: 100%;
    }
}

.thankyou-page-content a.back-home-btn {
    background: #20b8f9;
    color: #fff;
    font-size: 18px;
    width: 250px;
    border: 2px solid #20b8f9;
    border-radius: 0px;
    padding: 10px 10px;
    margin: 0 auto 10px;
    text-transform: uppercase;
    transition: all .3s ease-in-out;
    display: block;
    animation: cta2 3s infinite linear;
}

.thankyou-page-content a.back-home-btn:hover {
    background: #fff;
    color: #20b8f9;
}

/*Thankyou Page Section Css End Here*/

@media only screen and (min-width: 992px) and (max-width: 1199px) {

    /*Thankyou Page Section Responsive Css Start Here*/
    .thankyou-page-content h1 {
        font-size: 85px;
        line-height: 85px;
        letter-spacing: 20px;
        width: 90%;
    }

    .thankyou-page-content h1::before {
        width: 90%;
    }

    /*Thankyou Page Section Responsive Css End Here*/
}

@media only screen and (min-width: 768px) and (max-width: 991px) {

    /*Thankyou Page Section Responsive Css Start Here*/
    .thankyou-page-wrap::before {
        width: 300px;
        height: 300px;
    }

    .thankyou-page-wrap::after {
        width: 300px;
        height: 300px;
    }

    .thankyou-page-content h1 {
        font-size: 85px;
        line-height: 85px;
        letter-spacing: 20px;
        width: 100%;
    }

    .thankyou-page-content h1::before {
        width: 100%;
    }

    .thankyou-page-content a.back-home-btn {
        font-size: 16px;
    }

    /*Thankyou Page Section Responsive Css End Here*/
}

@media only screen and (min-width: 576px) and (max-width: 767px) {

    /*Thankyou Page Section Responsive Css Start Here*/
    .thankyou-page-wrap::before {
        width: 300px;
        height: 300px;
    }

    .thankyou-page-wrap::after {
        width: 300px;
        height: 300px;
    }

    .thankyou-page-content h1 {
        font-size: 60px;
        line-height: 60px;
        letter-spacing: 15px;
        width: 100%;
    }

    .thankyou-page-content h1::before {
        width: 100%;
    }

    .thankyou-page-content a.back-home-btn {
        font-size: 16px;
    }

    /*Thankyou Page Section Responsive Css End Here*/
}

@media only screen and (min-width: 300px) and (max-width: 575px) {

    /*Thankyou Page Section Responsive Css Start Here*/
    .thankyou-page-wrap::before {
        width: 200px;
        height: 200px;
    }

    .thankyou-page-wrap::after {
        width: 200px;
        height: 200px;
    }

    .thankyou-page-content h1 {
        font-size: 30px;
        line-height: 30px;
        letter-spacing: 10px;
        width: 100%;
    }

    .thankyou-page-content h1::before {
        width: 100%;
    }

    .thankyou-page-content a.back-home-btn {
        font-size: 16px;
    }

    /*Thankyou Page Section Responsive Css End Here*/
}
</style>

<body>
    <header>
        <section class="techVerse_navbar">
            <nav class="navbar navbar-expand-lg p-0">
                <a class="navbar-brand techVerse_logo" href="index">
                    <img src="images/logon.png" alt="" />
                </a>
                <div class="topbar">
                    <div class="call-first">
                        <a href="tel:<?php echo $locNumber; ?>">
                            <img src="images/cal.png" alt="" />
                            <span>Call Us: <?php echo $locNumber; ?></span>
                        </a>
                    </div>
                </div>
            </nav>
        </section>
    </header>
    <section class="thankyou-page-wrap">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-sm-12 col-md-12 col-lg-10 col-xl-10 col-xxl-10">
                    <div class="thankyou-page-content">
                        <h1 data-text="Thankyou...">Thankyou...</h1>
                        <p>We can already envision a bright future ahead for you. Our customer support team will be in
                            contact with you shortly. Now that you have sown the seeds of your success, we’ll ripen your
                            fruit of prosperity.</p>
                        <a href="index" class="btn_with_icon">
                            <span class="btn_with_icon_text">Click To Back!</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
    AOS.init();
    </script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.2/MotionPathPlugin.min.js"></script>
    <script src="js/partical.js"></script>
    <script src="js/app.js"></script>
    <script src="js/script.js"></script>
    <script src="js/custome.js"></script>
</body>

</html>