<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ajax Data With Tailwind</title>
    <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: "Poppins", sans-serif;
        }
    </style>
</head>
<body>
<section>
    <div class="container mx-auto py-5">
        <div class="ajax_wrapper">
            <h2 class="mb-2 text-5xl font-bold tracking-tight text-gray-900 uppercase text-center py-5">Subscriptions Data</h2>
            <div class="grid grid-cols-3 gap-4" id="subscriptions-container">
                <!-- Dynamic content will be inserted here -->
            </div>
            <div class="text-center mt-6" id="load-more-container">
                <button id="load-more-button" class="px-6 py-2 bg-gray-800 text-white rounded-lg hover:bg-blue-900 cursor-pointer transition ease-in">
                    Load More
                </button>
            </div>
        </div>
    </div>
</section>

<script>
    const endpoint = "https://api.github.com/users/wesbos/subscriptions";
    const subscriptionsContainer = document.getElementById('subscriptions-container');
    const loadMoreButton = document.getElementById('load-more-button');
    let allSubscriptions = [];
    let visibleCount = 9;
    const increment = 3; // Number of additional cards to show on each "Load More" click

    fetch(endpoint)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            allSubscriptions = data;
            renderSubscriptions(0, visibleCount); // Render initial cards
            toggleLoadMoreButton(); // Show/hide the "Load More" button based on remaining cards
        })
        .catch(error => {
            console.error('There was a problem with the fetch operation:', error);
            subscriptionsContainer.innerHTML = '<p class="text-red-500">Error loading subscriptions data.</p>';
        });

    // Function to render subscription cards
    function renderSubscriptions(start, end) {
        const fragment = document.createDocumentFragment();
        allSubscriptions.slice(start, end).forEach(subscription => {
            const subscriptionElement = document.createElement('a');
            subscriptionElement.href = subscription.fw || '#';  
            subscriptionElement.className = 'block p-6 bg-white border border-gray-200 rounded-lg shadow-sm hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:hover:bg-gray-700';

            // Add image
            const image = document.createElement('img');
            image.src = subscription.owner.avatar_url;
            image.alt = `${subscription.owner.login}'s avatar`;
            image.className = 'w-16 h-16 rounded-full mb-4';

            // Add title
            const title = document.createElement('h5');
            title.className = 'mb-2 text-2xl font-bold tracking-tight text-gray-900 dark:text-white';
            title.textContent = subscription.name || 'No title available';

            // Add description
            const description = document.createElement('p');
            description.className = 'font-normal text-gray-700 dark:text-gray-400';
            description.textContent = subscription.description || 'No description available';

            // Append elements to the subscription card
            subscriptionElement.appendChild(image);
            subscriptionElement.appendChild(title);
            subscriptionElement.appendChild(description);

            // Append the subscription card to the fragment
            fragment.appendChild(subscriptionElement);
        });

        // Append the fragment to the container
        subscriptionsContainer.appendChild(fragment);
    }

    // Function to toggle the "Load More" button visibility
    function toggleLoadMoreButton() {
        if (visibleCount >= allSubscriptions.length) {
            loadMoreButton.style.display = 'none'; // Hide the button if all cards are visible
        } else {
            loadMoreButton.style.display = 'inline-block'; // Show the button if there are more cards to load
        }
    }

    // Event listener for the "Load More" button
    loadMoreButton.addEventListener('click', () => {
        const nextCount = visibleCount + increment;
        renderSubscriptions(visibleCount, nextCount); // Render the next set of cards
        visibleCount = nextCount; // Update the visible count
        toggleLoadMoreButton(); // Toggle the button visibility
    });
</script>
</body>
</html>